/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs.sources;

import com.mojang.serialization.Codec;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSource;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSourceType;
import dev.toma.gunsrpg.common.init.ModDebuffSources;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.registry.Registry;

public class HurtByEntitySource
implements DebuffSource {
    public static final Codec<HurtByEntitySource> CODEC = Codec.unboundedMap((Codec)Registry.field_212629_r, (Codec)Codec.FLOAT).fieldOf("entityMap").xmap(HurtByEntitySource::new, t -> t.entityMap).codec();
    private final Map<EntityType<?>, Float> entityMap;

    public HurtByEntitySource(Map<EntityType<?>, Float> entityMap) {
        this.entityMap = entityMap;
    }

    public static boolean isValidEntitySource(DamageSource source) {
        return source instanceof EntityDamageSource && !((EntityDamageSource)source).func_180139_w() && source.func_76346_g() != null;
    }

    @Override
    public float getChance(IDebuffContext context) {
        DamageSource source = context.getSource();
        if (HurtByEntitySource.isValidEntitySource(source)) {
            Entity entity = source.func_76346_g();
            EntityType type = entity.func_200600_R();
            return this.entityMap.getOrDefault(type, Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    @Override
    public DebuffSourceType<?> getType() {
        return ModDebuffSources.HURT_BY_ENTITY;
    }
}

